<?php

namespace App\Http\Controllers\Crm\Brands;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class BrandsController extends Controller
{
    //view
    public function index(Request $request)
    {
        if ($request->session()->get('id') != null) {

            if(session()->get('usertype') == 1){
                $brands =[];

                $brnd = DB::table('brands')
                    ->select('*')
                    ->orderby('updated_at', 'desc')
                    ->get();
                foreach ($brnd as $rows) {
                    $get_assign_users = DB::table('brand_assign')
                                            ->select('brand_assign.*','users.id as manager_id','users.first_name','users.last_name','users.image')
                                            ->leftjoin('users','users.id','brand_assign.assign_user_id')
                                            ->where('brand_assign.brand_id',$rows->id)
                                            ->where('users.usertype_id',3)
                                            ->where('users.is_deleted', 0)
                                            ->get();
                    $data = [
                        'brand_id' => $rows->id,
                        'brand_name' => $rows->name,
                        'brand_url' => $rows->url,
                        'brand_type' => $rows->type,
                        'assign_managers' => $get_assign_users,
                    ];
                    array_push($brands, $data);
                }
                $depart_managers = DB::table('department_assign')
                                      ->select('department_assign.*','users.id','users.first_name','users.last_name','departments.name')
                                      ->leftjoin('users','users.id','department_assign.user_id')
                                      ->leftjoin('departments','departments.id','department_assign.department_id')
                                      ->where('users.usertype_id',3)
                                      ->where('users.is_deleted', 0)
                                      ->get();

                return view('pages.brands',compact('brands','depart_managers'));
            }
            elseif(session()->get('usertype') == 3){
                $brands =[];

                $brnd = DB::table('brand_assign')
                            ->select('brand_assign.*','brands.name as brandname','brands.url as brandurl','brands.type as brandtype','users.id as manager_id','users.first_name','users.last_name','users.image')
                            ->leftjoin('users','users.id','brand_assign.assign_user_id')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('brand_assign.assign_user_id',session()->get('id'))
                            ->get();
                foreach ($brnd as $rows) {
                    $get_assign_users = DB::table('brand_assign')
                                            ->select('brand_assign.*','users.id as manager_id','users.first_name','users.last_name','users.image')
                                            ->leftjoin('users','users.id','brand_assign.assign_user_id')
                                            ->where('brand_assign.brand_id',$rows->brand_id)
                                            ->where('users.parent_user_id',session()->get('id'))
                                            ->where('users.usertype_id',2)
                                            ->get();
                    $data = [
                        'brand_id' => $rows->brand_id,
                        'brand_name' => $rows->brandname,
                        'brand_url' => $rows->brandurl,
                        'brand_type' => $rows->brandtype,
                        'assign_managers' => $get_assign_users,
                    ];
                    array_push($brands, $data);
                }
                $depart_managers = DB::table('department_assign')
                                      ->select('department_assign.*','users.id','users.first_name','users.last_name','departments.name')
                                      ->leftjoin('users','users.id','department_assign.user_id')
                                      ->leftjoin('departments','departments.id','department_assign.department_id')
                                      ->where('users.parent_user_id', session()->get('id'))
                                      ->where('users.usertype_id',2)
                                      ->get();

                return view('pages.brands',compact('brands','depart_managers'));
            }
            elseif(session()->get('usertype') == 2){
                $brands =[];

                $brnd = DB::table('brand_assign')
                            ->select('brand_assign.*','brands.name as brandname','brands.url as brandurl','brands.type as brandtype','users.id as manager_id','users.first_name','users.last_name','users.image')
                            ->leftjoin('users','users.id','brand_assign.assign_user_id')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('brand_assign.assign_user_id',session()->get('id'))
                            ->get();
                foreach ($brnd as $rows) {
                    $get_assign_users = DB::table('brand_assign')
                                            ->select('brand_assign.*','users.id as manager_id','users.first_name','users.last_name','users.image')
                                            ->leftjoin('users','users.id','brand_assign.assign_user_id')
                                            ->where('brand_assign.brand_id',$rows->brand_id)
                                            ->where('users.usertype_id',4)
                                            ->get();
                    $data = [
                        'brand_id' => $rows->brand_id,
                        'brand_name' => $rows->brandname,
                        'brand_url' => $rows->brandurl,
                        'brand_type' => $rows->brandtype,
                        'assign_managers' => $get_assign_users,
                    ];
                    array_push($brands, $data);
                }
                // dd($brands);
                $depart_managers = DB::table('department_assign')
                                      ->select('department_assign.*','users.id','users.first_name','users.last_name','departments.name')
                                      ->leftjoin('users','users.id','department_assign.user_id')
                                      ->leftjoin('departments','departments.id','department_assign.department_id')
                                      ->where('users.parent_user_id',session()->get('id'))
                                      ->where('users.usertype_id',4)
                                      ->get();

                return view('pages.brands',compact('brands','depart_managers'));
            }
            elseif(session()->get('usertype') == 4){
                $brands =[];

                $brnd = DB::table('brand_assign')
                            ->select('brand_assign.*','brands.name as brandname','brands.url as brandurl','brands.type as brandtype','users.id as manager_id','users.first_name','users.last_name','users.image')
                            ->leftjoin('users','users.id','brand_assign.assign_user_id')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('brand_assign.assign_user_id',session()->get('id'))
                            ->get();
                foreach ($brnd as $rows) {
                    $get_assign_users = DB::table('brand_assign')
                                            ->select('brand_assign.*','users.id as manager_id','users.first_name','users.last_name','users.image')
                                            ->leftjoin('users','users.id','brand_assign.assign_user_id')
                                            ->where('brand_assign.brand_id',$rows->brand_id)
                                            ->where('users.usertype_id',4)
                                            ->get();
                    $data = [
                        'brand_id' => $rows->brand_id,
                        'brand_name' => $rows->brandname,
                        'brand_url' => $rows->brandurl,
                        'brand_type' => $rows->brandtype,
                        'assign_managers' => $get_assign_users,
                    ];
                    array_push($brands, $data);
                }
                return view('pages.brands',compact('brands'));
            }

        } else {

            return redirect()->route('login');
        }
    }

    //add brands
    public function addbrand(Request $request){

        $validate = $request->validate([
            'name' => 'required',
            'url' => 'required',
            'brand_type' => 'required'
        ]);

        $brand = [
            'name' => $request->name,
            'url' => $request->url,
            'type' => $request->brand_type
        ];

        $check_brand =  DB::table('brands')
                        ->where('name',$request->name)
                        ->orwhere('url',$request->url)
                        ->first();
        // dd($check_brand);
        if(empty($check_brand)){
            $insert_brand = DB::table('brands')->insertGetId($brand);

            if($insert_brand){
                // dd($request->depart_manager);
                // $count = count($request->depart_manager);

                if($request->depart_manager != null){
                    foreach ($request->depart_manager as $row) {
                        $data = [
                            "brand_id" => $insert_brand,
                            "assign_user_id" => $row,
                            "user_id" => session()->get('id')
                        ];
                        DB::table('brand_assign')->insert($data);
                    }
                }
                toastr()->success('Brand Add Successfully');
                return redirect()->route('brands');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('brands');
            }
        }else{
            toastr()->error('Brand Name & URL must be unique');
            return redirect()->route('brands');
        }
    }

    //update brands
    public function updatebrand(Request $request){

        // dd($request);
        $validate = $request->validate([
            'brandname' => 'required',
            'brandurl' => 'required',
            'brandtype' => 'required'
        ]);

        $id = $request->editbrandid;

        $brand = [
            'name' => $request->brandname,
            'url' => $request->brandurl,
            'type' => $request->brandtype
        ];

        $update_brand = DB::table('brands')->where('id', $id)->update($brand);
        
        if($update_brand == false){
            if(session()->get('usertype') == 1){
                $assign_managers = DB::table('brand_assign')
                                    ->select('brand_assign.*','users.usertype_id')
                                    ->leftjoin('users','users.id','brand_assign.assign_user_id')
                                    ->where('users.usertype_id',3)
                                    ->where('brand_assign.brand_id',$id)
                                    ->get();
            }
            elseif(session()->get('usertype') == 3){
                $assign_managers = DB::table('brand_assign')
                                    ->select('brand_assign.*','users.usertype_id')
                                    ->leftjoin('users','users.id','brand_assign.assign_user_id')
                                    ->where('users.usertype_id',2)
                                    ->where('brand_assign.brand_id',$id)
                                    ->get();
            }
            elseif(session()->get('usertype') == 2){
                $assign_managers = DB::table('brand_assign')
                                    ->select('brand_assign.*','users.usertype_id')
                                    ->leftjoin('users','users.id','brand_assign.assign_user_id')
                                    ->where('users.usertype_id',4)
                                    ->where('brand_assign.brand_id',$id)
                                    ->get();
            }

            if(count($assign_managers) > 0){
                // dd($assign_managers);
                foreach ($assign_managers as $row) {
                    DB::table('brand_assign')->where('id',$row->id)->delete();
                }
            }
            
            if(isset($request->depart_manager)){
                if(count($request->depart_manager) > 0){
                    foreach ($request->depart_manager as $row) {
                        $data = [
                            "brand_id" => $id,
                            "assign_user_id" => $row,
                            "user_id" => session()->get('id')
                        ];
                        DB::table('brand_assign')->insert($data);
                    }
                }
            }


            toastr()->success('Brand Update Successfully');
            return redirect()->route('brands');
        }
        else{
            toastr()->success('Brand Update Successfully');
            return redirect()->route('brands');
        }
    }

    //delete brand
    public function deletebrand(Request $request){

        if(session()->get('id') != null){

            $check_brand = DB::table('brands')
                ->where('id',$request->deletebrandid)
                ->delete();
            if($check_brand){
                toastr()->success('Brand Delete Successfully');
                return redirect()->route('brands');
            }
            else{
                toastr()->error('Something went wrong while deleting');
                return redirect()->route('brands');
            }
        }
        else{
            return redirect()->route('login');
        }
    }

}
